/*
  LadderDAC8 - Potentiometer Feedback (Serial Monitor Output)
  
  This example demonstrates the basic DC voltage generation capability of the 
  LadderDAC8 shield and tests the accuracy of the R-2R resistor network.
  No OLED display is required; results are monitored via the Serial Monitor.
  
  Place jumper to A0-DAC for feedback reading, then open the Serial Monitor
  (115200 baud) to test potentiometer input to DAC.

  Library: Mete Hoca LadderDAC 8
*/

#include <LadderDAC8.h>

LadderDAC8 dac;

void setup() {
  Serial.begin(115200);
  dac.begin();
  dac.setReference(4.98);
}

void loop() {
  int potValue = dac.readPotRaw();
  byte dacValue = dac.readPot();
  dac.write(dacValue);

  Serial.print("POT :" + String("     ").substring(String(potValue).length()) + potValue);
  Serial.print("  |  DAC Value:" + String("    ").substring(String(dacValue).length()) + dacValue);
  Serial.print("  |  Set DAC Voltage: "); Serial.print(dac.getDacVoltage(), 3);
  Serial.print("V  |  Feedback Voltage: "); Serial.print(dac.readFeedbackVoltage(), 3);
  Serial.println("V");

  delay(16);
}