#ifndef LADDERDAC8_H
#define LADDERDAC8_H

#include <Arduino.h>

#if defined(ARDUINO_ARCH_RENESAS)
    #include <FspTimer.h>
#endif

class LadderDAC8 {
public:
    LadderDAC8();

    void begin();
    void clear();
    void full();
    void write(uint8_t value);
    void writeBit(uint8_t bit, bool state);
    void writeVoltage(float volts);

    uint16_t readPotRaw();
    uint8_t readPot();
    uint16_t readFeedbackRaw();
    float readFeedbackVoltage();
    float getDacVoltage();
    uint8_t getPotPin();
    uint8_t getFeedbackPin();
    void setReference(float v);
    float getReference();

	void waveSine(float frequency);
	void waveSquare(float frequency);
	void waveTriangle(float frequency);
    void waveSawtooth(float frequency);
    void waveStop();
    void updateWaveFrequency(float frequency);

private:
    float _vref = 5.0;
    uint8_t _lastValue = 0;
    uint16_t _readStable(uint8_t pin);
};

void _updatePortMaps(uint8_t mode);
float _calcSmartFreq(float reqFreq);
void _updateFrequency(float frequency); 

#if defined(__AVR__)
    void _startTimerAVR(float frequency);
#elif defined(ARDUINO_ARCH_RENESAS)
    void r4Callback(timer_callback_args_t *args);
    void _startTimerR4(float frequency);
#endif


#endif